<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English strings for clickmeeting
 *
 * You can have a rather longer description of the file as well,
 * if you like, and it can span multiple lines.
 *
 * @package    mod_clickmeeting
 * @copyright  2024 Clickmeeting
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['modulename'] = 'ClickMeeting';
$string['modulenameplural'] = 'ClickMeeting';
$string['modulename_help'] = 'Use the ClickMeeting module to schedule your training. <br /> The ClickMeeting modul allows you to invite your students for training.';
$string['clickmeetingfieldset'] = 'Custom example fieldset';
$string['clickmeetingname'] = 'Conference name';
$string['clickmeetingname_help'] = 'This is the content of the help tooltip associated with the Clickmeetingname field. Markdown syntax is supported.';
$string['clickmeeting'] = 'ClickMeeting';
$string['clickmeeting:view'] = 'View clickmeeting content';
$string['pluginadministration'] = 'ClickMeeting administration';
$string['pluginname'] = 'ClickMeeting';


$string['settings:apiurl'] = 'API url';
$string['settings:apiurldesc'] = 'ClickMeeting API url';
$string['settings:apikey'] = 'API KEY <br />< Type or paste your <br />API KEY here>';
$string['settings:apikeydesc'] = 'To get more information about the ClickMeeting API platform, please visit <a href="http://dev.clickmeeting.com" target="_blank">dev.clickmeeting.com</a>';

$string['form:waitingmsg'] = 'Waiting room message';
$string['form:waitingmsg_help'] = 'The message is shown when waiting for the conference to begin. The maximum length is 255 characters.';
$string['form:maxduration'] = 'Duration';
$string['form:maxduration_help'] = 'Max duration in hours';
$string['form:data_header'] = 'Conference time';
$string['form:select_room_type'] = 'Room type';
$string['form:webinar'] = 'Webinar';
$string['form:meeting'] = 'Meeting';
$string['form:access_type'] = 'Access type';
$string['form:open'] = 'Open';
$string['form:password'] = 'Password';
$string['form:token'] = 'Token';
$string['form:no_sessions'] = 'Session already booked';

$string['view:action'] = 'Action';
$string['view:password'] = 'Password';
$string['view:room_name'] = 'Room name';
$string['view:room_date'] = 'Meeting date';
$string['view:joinmeeting'] = 'Join meeting';
$string['view:embed'] = 'Embed this room to your site';
$string['view:room_description'] = 'Description';
$string['view:copy_to_clipboard'] = 'Copy to clipboard';
$string['view:oldmeeting'] = 'This meeting already took a place';

$string['clickmeeting:addinstance'] = 'Adding';
$string['clickmeeting:host'] = 'Host';
$string['clickmeeting:listener'] = 'Listener';
$string['clickmeeting:presenter'] = 'Presenter';

$string['startdate_booked'] = 'This start date is already booked';
$string['update_error'] = 'Error updating record';
$string['api_404_error'] = '404 Not Found';

$string['privacy:metadata:clickmeeting_api'] = 'In order to integrate with Clickmeeting API, user data needs to be exchanged with that service.';
$string['privacy:metadata:clickmeeting_api:email'] = 'The user\'s e-mail address is sent from Moodle to allow you to access virtual classroom on the remote system.';
$string['privacy:metadata:clickmeeting_api:nickname'] = 'Your full name is sent to the remote system to access virtual classroom on the remote system.';

$string['privacy:metadata:clickmeetingtokens:userid'] = 'Access token is stored in context of user';
$string['privacy:metadata:clickmeetingtokens'] = 'Plugin stores tokens assigned to particular user';

